/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks;

import com.jesz.createdieselgenerators.blocks.BlockRegistry;
import com.jesz.createdieselgenerators.blocks.DieselGeneratorBlock;
import com.jesz.createdieselgenerators.blocks.ICDGKinetics;
import com.jesz.createdieselgenerators.blocks.entity.BlockEntityRegistry;
import com.jesz.createdieselgenerators.blocks.entity.LargeDieselGeneratorBlockEntity;
import com.jesz.createdieselgenerators.config.ConfigRegistry;
import com.jesz.createdieselgenerators.items.ItemRegistry;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PoleHelper;
import io.github.fabricators_of_create.porting_lib.block.ConnectableRedstoneBlock;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class LargeDieselGeneratorBlock
extends HorizontalKineticBlock
implements IBE<LargeDieselGeneratorBlockEntity>,
ISpecialBlockItemRequirement,
ICDGKinetics,
ConnectableRedstoneBlock {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 POWERED_BEFORE = class_2746.method_11825((String)"last_powered");
    public static final class_2746 PIPE = class_2746.method_11825((String)"pipe");
    public static final class_2746 SILENCED = class_2746.method_11825((String)"silenced");
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public LargeDieselGeneratorBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)super.method_9564().method_11657((class_2769)PIPE, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)SILENCED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DieselGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canConnectRedstone(class_2680 state, class_1922 level, class_2338 pos, @Nullable class_2350 direction) {
        return true;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighbourState, class_1936 level, class_2338 pos, class_2338 neighbourPos) {
        this.withBlockEntityDo((class_1922)level, pos, be -> {
            if (be.getEngineBack() == null) {
                be.updateStacked();
            }
        });
        return super.method_9559(state, direction, neighbourState, level, pos, neighbourPos);
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 itemInHand = player.method_5998(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (!player.method_5715() && player.method_7294() && placementHelper.matchesItem(itemInHand)) {
            placementHelper.getOffset(player, level, state, pos, hit).placeInWorld(level, (class_1747)itemInHand.method_7909(), player, hand, hit);
            return class_1269.field_5812;
        }
        if (ItemRegistry.ENGINE_SILENCER.isIn(itemInHand)) {
            if (((Boolean)state.method_11654((class_2769)SILENCED)).booleanValue()) {
                return class_1269.field_5811;
            }
            if (!player.method_7337()) {
                itemInHand.method_7934(1);
            }
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)SILENCED, (Comparable)Boolean.valueOf(true)), 3);
            this.playRotateSound(level, pos);
            return class_1269.field_5812;
        }
        if (!((Boolean)ConfigRegistry.ENGINES_FILLED_WITH_ITEMS.get()).booleanValue()) {
            return super.method_9534(state, level, pos, player, hand, hit);
        }
        if (itemInHand.method_7960()) {
            return class_1269.field_5811;
        }
        if (level.method_8321(pos) instanceof SmartBlockEntity) {
            FluidTankBlockEntity controllerBE;
            class_3611 fluid;
            FluidHelper.FluidExchange exchange = null;
            FluidTankBlockEntity be = (FluidTankBlockEntity)ConnectivityHandler.partAt(this.getBlockEntityType(), (class_1922)level, (class_2338)pos);
            if (be == null) {
                return class_1269.field_5814;
            }
            class_2350 direction = hit.method_17780();
            Storage fluidTank = be.getFluidStorage(direction);
            if (fluidTank == null) {
                return class_1269.field_5811;
            }
            FluidStack prevFluidInTank = TransferUtil.firstCopyOrEmpty((Storage)fluidTank);
            if (FluidHelper.tryEmptyItemIntoBE((class_1937)level, (class_1657)player, (class_1268)hand, (class_1799)itemInHand, (SmartBlockEntity)be, (class_2350)direction)) {
                exchange = FluidHelper.FluidExchange.ITEM_TO_TANK;
            } else if (FluidHelper.tryFillItemFromBE((class_1937)level, (class_1657)player, (class_1268)hand, (class_1799)itemInHand, (SmartBlockEntity)be, (class_2350)direction)) {
                exchange = FluidHelper.FluidExchange.TANK_TO_ITEM;
            }
            if (exchange == null) {
                if (GenericItemEmptying.canItemBeEmptied((class_1937)level, (class_1799)itemInHand) || GenericItemFilling.canItemBeFilled((class_1937)level, (class_1799)itemInHand)) {
                    return class_1269.field_5812;
                }
                return class_1269.field_5811;
            }
            class_3414 soundevent = null;
            class_2680 fluidState = null;
            FluidStack fluidInTank = TransferUtil.firstOrEmpty((Storage)fluidTank);
            if (exchange == FluidHelper.FluidExchange.ITEM_TO_TANK) {
                FluidStack fluidInItem;
                if (!level.field_9236 && !(fluidInItem = (FluidStack)GenericItemEmptying.emptyItem((class_1937)level, (class_1799)itemInHand, (boolean)true).getFirst()).isEmpty() && fluidTank instanceof CreativeFluidTankBlockEntity.CreativeSmartFluidTank) {
                    ((CreativeFluidTankBlockEntity.CreativeSmartFluidTank)fluidTank).setContainedFluid(fluidInItem);
                }
                fluid = fluidInTank.getFluid();
                fluidState = fluid.method_15785().method_15759();
                soundevent = FluidVariantAttributes.getEmptySound((FluidVariant)FluidVariant.of((class_3611)fluid));
            }
            if (exchange == FluidHelper.FluidExchange.TANK_TO_ITEM) {
                if (!level.field_9236 && fluidTank instanceof CreativeFluidTankBlockEntity.CreativeSmartFluidTank) {
                    ((CreativeFluidTankBlockEntity.CreativeSmartFluidTank)fluidTank).setContainedFluid(FluidStack.EMPTY);
                }
                fluid = prevFluidInTank.getFluid();
                fluidState = fluid.method_15785().method_15759();
                soundevent = FluidVariantAttributes.getFillSound((FluidVariant)FluidVariant.of((class_3611)fluid));
            }
            if (soundevent != null && !level.field_9236) {
                float pitch = class_3532.method_15363((float)(1.0f - 1.0f * (float)fluidInTank.getAmount() / (float)(FluidTankBlockEntity.getCapacityMultiplier() * 16L)), (float)0.0f, (float)1.0f);
                pitch /= 1.5f;
                pitch += 0.5f;
                level.method_8396(null, pos, soundevent, class_3419.field_15245, 0.5f, pitch += (level.field_9229.method_43057() - 0.5f) / 4.0f);
            }
            if (!fluidInTank.isFluidEqual(prevFluidInTank) && be instanceof FluidTankBlockEntity && (controllerBE = be.getControllerBE()) != null) {
                if (fluidState != null && !level.field_9236) {
                    class_2388 blockParticleData = new class_2388(class_2398.field_11217, fluidState);
                    float levelA = (float)fluidInTank.getAmount() / (float)TransferUtil.firstCapacity((Storage)fluidTank);
                    boolean reversed = FluidVariantAttributes.isLighterThanAir((FluidVariant)fluidInTank.getType());
                    if (reversed) {
                        levelA = 1.0f - levelA;
                    }
                    class_243 vec = hit.method_17784();
                    vec = new class_243(vec.field_1352, (double)((float)controllerBE.method_11016().method_10264() + levelA * ((float)controllerBE.getHeight() - 0.5f) + 0.25f), vec.field_1350);
                    class_243 motion = player.method_19538().method_1020(vec).method_1021((double)0.05f);
                    vec = vec.method_1019(motion);
                    level.method_8406((class_2394)blockParticleData, vec.field_1352, vec.field_1351, vec.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
                    return class_1269.field_5812;
                }
                controllerBE.sendDataImmediately();
                controllerBE.method_5431();
            }
        }
        return super.method_9534(state, level, pos, player, hand, hit);
    }

    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        if (context.method_8038() == class_2350.field_11036) {
            KineticBlockEntity.switchToBlockState((class_1937)context.method_8045(), (class_2338)context.method_8037(), (class_2680)this.updateAfterWrenched((class_2680)state.method_11657((class_2769)PIPE, (Comparable)Boolean.valueOf((Boolean)state.method_11654((class_2769)PIPE) == false)), context));
            this.playRotateSound(context.method_8045(), context.method_8037());
            return class_1269.field_5812;
        }
        if (((Boolean)state.method_11654((class_2769)SILENCED)).booleanValue() && context.method_8036() != null && !context.method_8045().field_9236) {
            if (!context.method_8036().method_7337()) {
                context.method_8036().method_31548().method_7398(ItemRegistry.ENGINE_SILENCER.asStack());
            }
            context.method_8045().method_8652(context.method_8037(), (class_2680)state.method_11657((class_2769)SILENCED, (Comparable)Boolean.valueOf(false)), 3);
            this.playRotateSound(context.method_8045(), context.method_8037());
            return class_1269.field_5812;
        }
        return super.onWrenched(state, context);
    }

    public class_2680 getRotatedBlockState(class_2680 originalState, class_2350 targetedFace) {
        return originalState;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{PIPE, SILENCED, DieselGeneratorBlock.POWERED});
        super.method_9515(builder);
    }

    public class_2680 method_9605(class_1750 pContext) {
        if (pContext.method_8036().method_5715()) {
            return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)pContext.method_8042());
        }
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)pContext.method_8042().method_10153());
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 otherPos, boolean moving) {
        this.withBlockEntityDo((class_1922)level, pos, be -> {
            LargeDieselGeneratorBlockEntity front = (LargeDieselGeneratorBlockEntity)((Object)((Object)be.frontEngine.get()));
            if (front == null) {
                front = be;
            }
            if (front != be) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)DieselGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(level.method_49803(pos))), 2);
            }
            if (!((Boolean)front.method_11010().method_11654((class_2769)DieselGeneratorBlock.POWERED)).booleanValue() && level.method_49803(pos)) {
                level.method_8652(front.method_11016(), (class_2680)front.method_11010().method_11657((class_2769)DieselGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(true)), 2);
            }
            if (((Boolean)front.method_11010().method_11654((class_2769)DieselGeneratorBlock.POWERED)).booleanValue() && !level.method_49803(pos)) {
                boolean atLeastOneEnginePowered = false;
                for (int i = 0; i < front.stacked; ++i) {
                    class_2680 bs = level.method_8320(pos.method_30513(((class_2350)state.method_11654((class_2769)FACING)).method_10166(), -i));
                    if (!(bs.method_26204() instanceof LargeDieselGeneratorBlock) || ((class_2350)bs.method_11654((class_2769)FACING)).method_10166() != ((class_2350)state.method_11654((class_2769)FACING)).method_10166() || !((Boolean)bs.method_11654((class_2769)DieselGeneratorBlock.POWERED)).booleanValue()) continue;
                    atLeastOneEnginePowered = true;
                    break;
                }
                if (!atLeastOneEnginePowered) {
                    level.method_8652(front.method_11016(), (class_2680)front.method_11010().method_11657((class_2769)DieselGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(false)), 2);
                }
            }
        });
        super.method_9612(state, level, pos, block, otherPos, moving);
    }

    public Class<LargeDieselGeneratorBlockEntity> getBlockEntityClass() {
        return LargeDieselGeneratorBlockEntity.class;
    }

    public class_2591<? extends LargeDieselGeneratorBlockEntity> getBlockEntityType() {
        return (class_2591)BlockEntityRegistry.LARGE_DIESEL_ENGINE.get();
    }

    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        if (pState.method_11654((class_2769)FACING) == class_2350.field_11043 || pState.method_11654((class_2769)FACING) == class_2350.field_11035) {
            return class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (class_265)class_2248.method_9541((double)-2.0, (double)0.0, (double)0.0, (double)18.0, (double)4.0, (double)16.0));
        }
        return class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)-2.0, (double)16.0, (double)4.0, (double)18.0));
    }

    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return ((class_2350)state.method_11654((class_2769)FACING)).method_10166() == face.method_10166();
    }

    public class_2350.class_2351 getRotationAxis(class_2680 blockState) {
        return ((class_2350)blockState.method_11654((class_2769)FACING)).method_10166();
    }

    public ItemRequirement getRequiredItems(class_2680 state, class_2586 blockEntity) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        list.add(BlockRegistry.MODULAR_DIESEL_ENGINE.asStack());
        if (((Boolean)state.method_11654((class_2769)SILENCED)).booleanValue()) {
            list.add(ItemRegistry.ENGINE_SILENCER.asStack());
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, list);
    }

    @Override
    public float getDefaultStressCapacity() {
        return 2048.0f;
    }

    @Override
    public float getDefaultStressStressImpact() {
        return 0.0f;
    }

    @Override
    public float getDefaultSpeed() {
        return 96.0f;
    }

    private static class PlacementHelper
    extends PoleHelper<class_2350> {
        public PlacementHelper() {
            super(arg_0 -> BlockRegistry.MODULAR_DIESEL_ENGINE.has(arg_0), state -> ((class_2350)state.method_11654((class_2769)FACING)).method_10166(), (class_2769)FACING);
        }

        public Predicate<class_1799> getItemPredicate() {
            return arg_0 -> BlockRegistry.MODULAR_DIESEL_ENGINE.isIn(arg_0);
        }
    }
}

